GO
IF NOT EXISTS(SELECT * FROM sys.columns
WHERE Name = N'BookingManagerActive' AND OBJECT_ID = OBJECT_ID(N'[Reservations]'))
BEGIN
	ALTER TABLE [dbo].[Reservations] ADD [BookingManagerActive] INT not null default 1
END 
GO
IF NOT EXISTS(SELECT * FROM sys.columns
WHERE Name = N'BookingManagerTime' AND OBJECT_ID = OBJECT_ID(N'[Reservations]'))
BEGIN
	ALTER TABLE [dbo].[Reservations] ADD [BookingManagerTime] DATETIME not null default GETUTCDATE()
END 
GO
---------------------------------------table BookingManagerMessage------------------------------------
if not exists (select * from sysobjects where name='BookingManagerMessage' and xtype='U')
begin
    CREATE TABLE BookingManagerMessage
	(
	Id INT NOT NULL IDENTITY(1,1) CONSTRAINT pk_BookingManagerMessage_mid PRIMARY KEY,
	Created DATETIME,
	PersonId INT CONSTRAINT fk_BookingManagerMessage_pid FOREIGN KEY REFERENCES Persons(id),
	GlobalId NVARCHAR(450),
	ResourceId INT CONSTRAINT fk_BookingManagerMessage_rid FOREIGN KEY REFERENCES Resources(id),
	[Message] NTEXT,
	IsProcessing bit not null default 1
	);

	CREATE NONCLUSTERED INDEX [ix_BookingManagerMessage_GlobalId] 
	ON BookingManagerMessage ([GlobalId])
end
GO
-- add new column NewStartDate into BookingManagerMessage table
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'NewStartDate' and Object_ID = Object_ID(N'BookingManagerMessage'))
 ALTER TABLE [dbo].[BookingManagerMessage] ADD [NewStartDate] [datetime] NULL
GO
-- add new column NewEndDate into BookingManagerMessage table
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'NewEndDate' and Object_ID = Object_ID(N'BookingManagerMessage'))
 ALTER TABLE [dbo].[BookingManagerMessage] ADD [NewEndDate] [datetime] NULL
GO
-- add new column IsNewResource into BookingManagerMessage table
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'IsNewResource' and Object_ID = Object_ID(N'BookingManagerMessage'))
 ALTER TABLE [dbo].[BookingManagerMessage] ADD [IsNewResource] [bit] NULL
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RestoreBookingManager]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RestoreBookingManager]
GO
CREATE PROCEDURE [dbo].[RestoreBookingManager] 
@RestoringTime  As varchar(255)
AS
BEGIN
	IF (@RestoringTime Is NOT NULL AND ISNUMERIC(LTrim(RTrim(@RestoringTime)))=1 )  
	Begin
		UPDATE Reservations SET BookingManagerActive = 1,BookingManagerTime = GETUTCDATE()
		WHERE BookingManagerActive = 0 
		AND DATEADD(MINUTE,-CONVERT(NUMERIC,LTRIM(RTRIM(@RestoringTime))),GETUTCDATE()) > BookingManagerTime
		UPDATE BookingManagerMessage SET IsProcessing = 0
		WHERE IsProcessing = 1 
		AND DATEADD(MINUTE,-CONVERT(NUMERIC,LTRIM(RTRIM(@RestoringTime))),GETUTCDATE()) > Created
	END
	ELSE
	BEGIN
		UPDATE Reservations SET BookingManagerActive = 1,BookingManagerTime = GETUTCDATE()
		WHERE BookingManagerActive = 0 
		AND DATEADD(MINUTE,-CONVERT(NUMERIC,LTRIM(RTRIM(10))),GETUTCDATE()) > BookingManagerTime

		UPDATE BookingManagerMessage SET IsProcessing = 0
		WHERE IsProcessing = 1 
		AND DATEADD(MINUTE,-CONVERT(NUMERIC,LTRIM(RTRIM(10))),GETUTCDATE()) > Created
	END
END
GO

if not exists (select 1 from Tree where [Key]='BookingManager')
begin
-----insert into URLMapping-----
	declare @MaxFunctionId int = (select MAX(FunctionId) from URLMapping)
	declare @BookingManagerFunctionId int = @MaxFunctionId + 1
	insert into URLMapping(FunctionId,Created,LastUpdated,FunctionHandler) values(@BookingManagerFunctionId,GETUTCDATE(),GETUTCDATE(),'BookingManager.aspx')
-----insert into Tree-----
	declare @MaxTreeNodeId int = (select top 1 LastID from TableKeys where TableName = 'Tree')
	declare @BookingManagerNodeId int = @MaxTreeNodeId + 1
	declare @ParentNodeId int = (select top 1 id from Tree where [Key] = '@DAILYTASKS')
	insert into Tree(id,Created,LastUpdated,parentNodeId,[Key],Caption,SortOrder,IsApplicationNode,FunctionId,IconKey,CustomCalendarId,NodeType)
	values(@BookingManagerNodeId,GETUTCDATE(),GETUTCDATE(),@ParentNodeId,'BookingManager','Booking Manager',4,1,@BookingManagerFunctionId,'Orders',1,0)
-----insert into acl-----
	insert into acl(Created,LastUpdated,RoleId,TreeNodeId,actionId,Allow) 
	values(GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,1,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,2,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,3,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,4,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,5,1)
-----update TableKeys------------------
    Update TableKeys set LastID = @BookingManagerNodeId where TableName = 'Tree'
end
GO

--------------ToolBar "Clear Filter"-----------------------------
declare @MaxToolbarFunctionsId int = (select Max(id) from ToolbarFunctions)
declare @ClearFilterId int = @MaxToolbarFunctionsId + 1
IF NOT EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@ClearFilter')
BEGIN
insert into ToolbarFunctions(id,FunctionName,Caption,DescriptionShort,iconRef) values(@ClearFilterId,'@ClearFilter','Clear Filter','Set all filters for this view','../images/Filter.gif')
END

------------------sp_MiniRF_NormalResources_SelectedResourceList---------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_MiniRF_NormalResources_SelectedResourceList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_MiniRF_NormalResources_SelectedResourceList]
GO
CREATE PROCEDURE [dbo].[sp_MiniRF_NormalResources_SelectedResourceList]
@ResourceIDs varchar(512) = '',
@sortColumn varchar(100),
@sqlSortDir varchar(4),
@locationPath varchar(MAX),
@categoryList varchar(MAX),
@nameToSearch nvarchar(256),
@searchOperator varchar(2),
@capacityValue INT,
@filterAndOr INT,
@categoryFilter varchar(MAX),
@locationFilter varchar(MAX)
AS 
BEGIN
SET NOCOUNT ON
DECLARE @categoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @locationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterLocationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterCategoryTBL TABLE(Id INT,Data varchar(MAX))
INSERT @categoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryList,',') OPTION (MAXRECURSION 0)
INSERT @locationTBL
SELECT * FROM [dbo].[udfSplitString](@locationPath,',') OPTION (MAXRECURSION 0)
INSERT @filterLocationTBL
SELECT * FROM [dbo].[udfSplitString](@locationFilter,',') OPTION (MAXRECURSION 0)
INSERT @filterCategoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryFilter,',') OPTION (MAXRECURSION 0)
DECLARE @resInOrder TABLE(ID INT,Name nvarchar(256),ImageHref nvarchar(256),RessourceMail nvarchar(256),LocationPath INT,Capacity INT,AllowConflictMeeting INT,CommonFormId INT,SortOrder NVARCHAR(256),utcStartTime datetime,utcEndTime datetime)
INSERT @resInOrder
select  ID,Name,ImageHref,RessourceMail,LocationPath,Capacity,AllowConflictMeeting,
            CommonFormId,SortOrder ,StartTime as utcStartTime, EndTime as utcEndTime
from Resources R  
Where (ID in (select Data from [dbo].[udfSplitString](@ResourceIDs,',') WHERE Data !=''))
AND    (Name LIKE '%'+@nameToSearch+'%' OR @nameToSearch='')
AND(
	(@searchOperator ='=' AND Capacity = @capacityValue)
OR (@searchOperator ='>' AND Capacity > @capacityValue)
OR (@searchOperator ='<' AND Capacity < @capacityValue)
OR (@searchOperator ='>=' AND Capacity >= @capacityValue)
OR (@searchOperator ='<=' AND Capacity <= @capacityValue)
OR @capacityValue = -1)
AND 
(
(
Category1 IN (SELECT Data FROM @categoryTBL)
OR Category2 IN (SELECT Data FROM @categoryTBL)
OR Category3 IN (SELECT Data FROM @categoryTBL)
OR Category4 IN (SELECT Data FROM @categoryTBL)
OR Category5 IN (SELECT Data FROM @categoryTBL)
OR @categoryList = ''
)
AND
(
	LocationPath IN (SELECT Data FROM @locationTBL)
	--OR @locationPath = ''
)
)
AND (
	@filterAndOr=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR @locationFilter ='')
			AND (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR  @categoryFilter=''
				)
		)
	OR @filterAndOr =-1			
	)
AND	(
	@filterAndOr!=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR (@locationFilter ='' AND @categoryFilter=''))
			OR (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR (@locationFilter ='' AND @categoryFilter='')
				)
		)
	OR @filterAndOr =-1		
	)
AND CommonFormId IS NULL -- not include SOF resources.
SELECT * FROM @resInOrder
ORDER BY SortOrder,
		 CASE WHEN @sortColumn='name' AND @sqlSortDir = 'asc' THEN Convert(nvarchar(256),Name) END,
		 CASE WHEN @sortColumn='capacity' AND @sqlSortDir = 'asc'THEN Capacity END,
		 CASE WHEN @sortColumn='name' AND @sqlSortDir = 'desc' THEN Convert(nvarchar(256),Name) END DESC,
		 CASE WHEN @sortColumn='capacity' AND @sqlSortDir = 'desc' THEN Capacity END DESC
END
 
GO
-------------sp_MiniRF_ListNormalResources_Avaiable_Count------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_MiniRF_ListNormalResources_Avaiable_Count]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_MiniRF_ListNormalResources_Avaiable_Count]
GO
CREATE PROCEDURE [dbo].[sp_MiniRF_ListNormalResources_Avaiable_Count]
(
@personId INT,
@startTime DATETIME,
@endTime DATETIME,
@startTimeTotalMinutes INT,
@endTimeTotalMinutes INT,
@locationPath varchar(MAX),
@categoryList varchar(MAX),
@nameToSearch nvarchar(256),
@searchOperator varchar(2),
@capacityValue INT,
@filterAndOr INT,
@categoryFilter varchar(MAX),
@locationFilter varchar(MAX)
)
AS
BEGIN
SET NOCOUNT ON
DECLARE @selectFrom INT,@selectTO INT
DECLARE @categoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @locationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterLocationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterCategoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @tempResourceRerveration TABLE(ResId INT)

INSERT @categoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryList,',') OPTION (MAXRECURSION 0)
INSERT @locationTBL
SELECT * FROM [dbo].[udfSplitString](@locationPath,',') OPTION (MAXRECURSION 0)
INSERT @filterLocationTBL
SELECT * FROM [dbo].[udfSplitString](@locationFilter,',') OPTION (MAXRECURSION 0)
INSERT @filterCategoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryFilter,',') OPTION (MAXRECURSION 0)
DECLARE @ResourceAssignment TABLE(ResourceId int)
INSERT INTO @ResourceAssignment SELECT DISTINCT ResourceId FROM [dbo].[RelationsAssignments] WHERE PersonId = @personId

INSERT INTO @tempResourceRerveration
SELECT DISTINCT id FROM (SELECT  rs.id, 
DATEADD(MINUTE, - (rs.PreBufferTime), r.StartDate) AS PBStartDate, 
DATEADD(MINUTE, rs.PostBufferTime, r.EndDate) AS PBEndDate,
rs.StartTime  AS utcStartTime,rs.EndTime AS utcEndTime 
FROM        Reservations r 
INNER JOIN  Resources rs
ON			r.RessourceId = rs.id 
WHERE		(r.Active = 1 OR r.BusyStatus='BUSY')
AND (IsRecurring <> 2) AND EXISTS (SELECT 1 FROM @ResourceAssignment WHERE ResourceId = rs.id)
)as tbl
where (PBStartDate>=@startTime AND PBStartDate<@endTime) 
OR (PBEndDate<=@endTime AND PBEndDate>@startTime)
OR (PBStartDate<=@startTime AND PBEndDate>=@endTime)
--Remove all Shared Order resources
union select id from Resources where CommonFormId is not null
--Remove all VR of its' child resource unavailable
insert @tempResourceRerveration
select DISTINCT VirtualResourceId from ChildResources where ChildResourceId in (select ResId from @tempResourceRerveration)

SELECT COUNT(id) AS "TotalRows"  from Resources
WHERE id IN (SELECT id FROM @ResourceAssignment) AND id NOT IN (SELECT ResId FROM @tempResourceRerveration)
AND (Visible IS NULL OR Visible='1')
AND 
(
(dbo.fn_Resource_OpenTimeToInt(StartTime)<=@startTimeTotalMinutes 
AND dbo.fn_Resource_CloseTimeToInt(EndTime)>=@endTimeTotalMinutes)
OR StartTime=EndTime
)
AND (Name LIKE '%'+@nameToSearch+'%' OR @nameToSearch='')
AND(
	(@searchOperator ='=' AND Capacity = @capacityValue)
OR (@searchOperator ='>' AND Capacity > @capacityValue)
OR (@searchOperator ='<' AND Capacity < @capacityValue)
OR (@searchOperator ='>=' AND Capacity >= @capacityValue)
OR (@searchOperator ='<=' AND Capacity <= @capacityValue)
OR @capacityValue = -1)
AND 
(
(
Category1 IN (SELECT Data FROM @categoryTBL)
OR Category2 IN (SELECT Data FROM @categoryTBL)
OR Category3 IN (SELECT Data FROM @categoryTBL)
OR Category4 IN (SELECT Data FROM @categoryTBL)
OR Category5 IN (SELECT Data FROM @categoryTBL)
OR @categoryList = ''
)
AND
(
	LocationPath IN (SELECT Data FROM @locationTBL)
	--OR @locationPath = ''
)
)
AND (
	@filterAndOr=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR @locationFilter ='')
			AND (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR  @categoryFilter=''
				)
		)
	OR @filterAndOr =-1			
	)
AND	(
	@filterAndOr!=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR (@locationFilter ='' AND @categoryFilter=''))
			OR (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR (@locationFilter ='' AND @categoryFilter='')
				)
		)
	OR @filterAndOr =-1		
	)
AND CommonFormId IS NULL -- not include SOF resources.
END
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_MiniRF_ListNormalResources_Avaiable]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_MiniRF_ListNormalResources_Avaiable]
GO
CREATE PROCEDURE [dbo].[sp_MiniRF_ListNormalResources_Avaiable] 
(
@personId INT,
@startTime DATETIME,
@endTime DATETIME,
@startTimeTotalMinutes INT,
@endTimeTotalMinutes INT,
@pageSize INT,
@pageIndex INT,
@sortColumn varchar(100),
@sqlSortDir varchar(4),
@locationPath varchar(MAX),
@categoryList varchar(MAX),
@nameToSearch nvarchar(256),
@searchOperator varchar(2),
@capacityValue INT,
@filterAndOr INT,
@categoryFilter varchar(MAX),
@locationFilter varchar(MAX)
)
AS
BEGIN
SET NOCOUNT ON
DECLARE @selectFrom INT,@selectTO INT
DECLARE @categoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @locationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterLocationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterCategoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @tempResourceRerveration TABLE(ResId INT)

INSERT @categoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryList,',') OPTION (MAXRECURSION 0)
INSERT @locationTBL
SELECT * FROM [dbo].[udfSplitString](@locationPath,',') OPTION (MAXRECURSION 0)
INSERT @filterLocationTBL
SELECT * FROM [dbo].[udfSplitString](@locationFilter,',') OPTION (MAXRECURSION 0)
INSERT @filterCategoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryFilter,',') OPTION (MAXRECURSION 0)
SET @selectFrom = (@pageIndex-1) * @pageSize + 1
SET @selectTO = @pageSize * (@pageIndex)
DECLARE @ResourceAssignment TABLE(ResourceId int)
INSERT INTO @ResourceAssignment SELECT DISTINCT ResourceId FROM [dbo].[RelationsAssignments] WHERE PersonId = @personId

INSERT INTO @tempResourceRerveration
SELECT DISTINCT id FROM (SELECT  rs.id, 
DATEADD(MINUTE, - (rs.PreBufferTime), r.StartDate) AS PBStartDate, 
DATEADD(MINUTE, rs.PostBufferTime, r.EndDate) AS PBEndDate,
rs.StartTime  AS utcStartTime,rs.EndTime AS utcEndTime 
FROM        Reservations r 
INNER JOIN  Resources rs
ON			r.RessourceId = rs.id 
WHERE		(r.Active = 1 OR r.BusyStatus='BUSY')
AND (IsRecurring <> 2) AND EXISTS (SELECT 1 FROM @ResourceAssignment WHERE ResourceId = rs.id)
)as tbl
where (PBStartDate>=@startTime AND PBStartDate<@endTime) 
OR (PBEndDate<=@endTime AND PBEndDate>@startTime)
OR (PBStartDate<=@startTime AND PBEndDate>=@endTime)
--Remove all Shared Order resources
union select id from Resources where CommonFormId is not null
--Remove all VR of its' child resource unavailable
insert @tempResourceRerveration
select DISTINCT VirtualResourceId from ChildResources where ChildResourceId in (select ResId from @tempResourceRerveration)

SELECT * FROM
(SELECT ID,Name,ImageHref,RessourceMail,LocationPath,Capacity,AllowConflictMeeting,AutoAcceptAgent,
			  CommonFormId,SortOrder,ROW_NUMBER() OVER (ORDER BY SortOrder,
													   CASE WHEN @sortColumn='name' AND @sqlSortDir = 'asc' THEN Convert(nvarchar(256),Name) END,
													   CASE WHEN @sortColumn='capacity' AND @sqlSortDir = 'asc'THEN Capacity END,
													   CASE WHEN @sortColumn='name' AND @sqlSortDir = 'desc' THEN Convert(nvarchar(256),Name) END DESC,
													   CASE WHEN @sortColumn='capacity' AND @sqlSortDir = 'desc' THEN Capacity END DESC) AS RN,StartTime as utcStartTime, EndTime as utcEndTime from Resources
WHERE id IN (SELECT id FROM @ResourceAssignment)
AND id NOT IN (SELECT ResId FROM @tempResourceRerveration)
AND (Visible IS NULL OR Visible='1')
AND (
(dbo.fn_Resource_OpenTimeToInt(StartTime)<=@startTimeTotalMinutes AND dbo.fn_Resource_CloseTimeToInt(EndTime)>=@endTimeTotalMinutes) OR
(dbo.fn_Resource_OpenTimeToInt(StartTime)>=@startTimeTotalMinutes AND dbo.fn_Resource_CloseTimeToInt(EndTime)>=@endTimeTotalMinutes) OR StartTime=EndTime)
AND (Name LIKE '%'+@nameToSearch+'%' OR @nameToSearch='')
AND(
	(@searchOperator ='=' AND Capacity = @capacityValue)
OR (@searchOperator ='>' AND Capacity > @capacityValue)
OR (@searchOperator ='<' AND Capacity < @capacityValue)
OR (@searchOperator ='>=' AND Capacity >= @capacityValue)
OR (@searchOperator ='<=' AND Capacity <= @capacityValue)
OR @capacityValue = -1)
AND 
(
(
Category1 IN (SELECT Data FROM @categoryTBL)
OR Category2 IN (SELECT Data FROM @categoryTBL)
OR Category3 IN (SELECT Data FROM @categoryTBL)
OR Category4 IN (SELECT Data FROM @categoryTBL)
OR Category5 IN (SELECT Data FROM @categoryTBL)
OR @categoryList = ''
)
AND
(
	LocationPath IN (SELECT Data FROM @locationTBL)
	--OR @locationPath = ''
)
)
AND (
	@filterAndOr=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR @locationFilter ='')
			AND (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR  @categoryFilter=''
				)
		)
	OR @filterAndOr =-1			
	)
AND	(
	@filterAndOr!=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR (@locationFilter ='' AND @categoryFilter=''))
			OR (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR (@locationFilter ='' AND @categoryFilter='')
				)
		)
	OR @filterAndOr =-1		
	)
AND CommonFormId IS NULL -- not include SOF resources.
) temp
WHERE temp.RN BETWEEN @selectFrom AND @selectTO
END
GO
--------------udfReservationExcludeVRScreenView---------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'dbo.udfReservationExcludeVRScreenView') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
      DROP FUNCTION [dbo].[udfReservationExcludeVRScreenView] 
END
GO
CREATE FUNCTION [dbo].[udfReservationExcludeVRScreenView] ( 
@CurrentDate      AS DATETIME, 
@PreviousDayCount AS INT, 
@FutureDayCount   AS INT) 
returns TABLE 
AS 
    RETURN 
      (SELECT DISTINCT dbo.reservations.id                                                             AS ReservationsID,
                       dbo.reservations.startdate, 
                       dbo.reservations.enddate, 
                       dbo.resources.Name                                                           AS Resource,
                       dbo.reservations.subject, 
                       Isnull(dbo.reservations.organizeremail + ' (' 
                              + dbo.reservations.organizername + ')', dbo.reservations.organizeremail) AS Organizer,
                       dbo.reservations.isrecurring, 
                       dbo.resources.id                                                                AS ResourceID,
					   dbo.resources.AllowConflictMeeting											   AS ConflictingMeeting,
					   dbo.resources.AutoAcceptAgent											       AS AllowConflicts,
					   dbo.resources.StartTime														   AS StartTime,
					   dbo.resources.EndTime														   AS EndTime,
					   dbo.Resources.PreBufferTime                                                     AS PreBufferTime,
					   dbo.Resources.PostBufferTime                                                    AS PostBufferTime,
                       (SELECT pv.valuetext 
                        FROM   dbo.propertytypes AS pt 
                               INNER JOIN dbo.propertyvalues AS pv 
                                       ON pt.id = pv.propertyid 
                                          AND pt.name = 'RC_OrganizerName' 
                                          AND dbo.reservations.id = pv.reservationid)                  AS OrganizerName,
                       dbo.reservations.resourcelocation                                               AS Location,
                       resources.locationpath                                                          AS LocationPath,
                       IsRecurringCol = CASE 
                                          WHEN ( isrecurring IS NOT NULL 
                                                 AND isrecurring = 0 ) THEN '' 
                                          ELSE '<img src=''../images/check.gif''></img>' 
                                        END,
					   CommonFormId = ISNULL(dbo.resources.CommonFormId,0),
					   dbo.reservations.organizeremail AS OrganizerEmail,
					   ISNULL(dbo.reservations.organizername,'') AS OrgName,
					   dbo.resources.TimeZone_StandardName AS TimeZone_StandardName,
					   dbo.Resources.SortOrder as ResourceSortOrder
       FROM   dbo.reservations 
              INNER JOIN dbo.resources 
                      ON dbo.reservations.ressourceid = dbo.resources.id 
        WHERE  dbo.reservations.startdate >= Dateadd(day, -@PreviousDayCount, @CurrentDate) 
              AND dbo.reservations.startdate <= Dateadd(day, @FutureDayCount, @CurrentDate) 
              AND dbo.reservations.isrecurring <> 2 
			  AND dbo.Reservations.Active <> 0
              AND Reservations.BusyStatus='BUSY')

GO
--------------fn_Resource_GetVRStringIds---------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'dbo.fn_Resource_GetVRStringIds') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
      DROP FUNCTION [dbo].[fn_Resource_GetVRStringIds] 
END
GO
CREATE FUNCTION [dbo].[fn_Resource_GetVRStringIds]
(
	-- Add the parameters for the function here
	@ResourceId int
)
RETURNS nvarchar(max)
AS
BEGIN
	declare @result nvarchar(20) = ''
	select 
	@result = ISNULL(@result,'') +',' + ISNULL(CAST(cr.VirtualResourceId as varchar(10)),'')--CONCAT(@result,',',cr.VirtualResourceId)
	from ChildResources cr
	where ChildResourceId = @ResourceId
	return @result
END
GO
--------------fn_Resource_GetVRStringIds---------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'dbo.fn_Resource_GetChildIds') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
      DROP FUNCTION [dbo].[fn_Resource_GetChildIds] 
END
GO
CREATE FUNCTION [dbo].[fn_Resource_GetChildIds]
(
	-- Add the parameters for the function here
	@ResourceId int
)
RETURNS nvarchar(max)
AS
BEGIN
	declare @result nvarchar(20) = ''
	select 
	@result = ISNULL(@result,'') + ',' + ISNULL(CAST(cr.ChildResourceId as varchar(10)),'') --CONCAT(@result,',',cr.ChildResourceId)
	from ChildResources cr
	where VirtualResourceId = @ResourceId
	return @result
END
GO
---------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsViolatedRecurringRules]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[IsViolatedRecurringRules]
GO
CREATE PROCEDURE [dbo].[IsViolatedRecurringRules] 
	-- Add the parameters for the stored procedure here
	@ReservationId int, 
	@Uid nvarchar(256),
	@OldDate datetime,
	@NewDate datetime
AS
BEGIN
DECLARE @Min datetime = (SELECT Min(StartDate)
						   FROM Reservations
						   WHERE [UID] = @Uid
							AND IsRecurring <> 2) 
DECLARE @MinOfMin datetime = FLOOR(CAST(@Min AS float)) 
DECLARE @MaxOfMin datetime = DATEADD(DAY, 1, @MinOfMin)
 
DECLARE @Max datetime = (SELECT Max(StartDate)
						   FROM Reservations
						   WHERE [UID] = @Uid
							AND IsRecurring <> 2) 
DECLARE @MinOfMax datetime = FLOOR(CAST(@Max AS float)) 
DECLARE @MaxOfMax datetime = DATEADD(DAY, 1, @MinOfMax) 

DECLARE @Current datetime = GETUTCDATE() 

IF @OldDate BETWEEN @MinOfMin AND @MaxOfMin 
BEGIN 
	IF (@NewDate > @MaxOfMax) OR (@NewDate BETWEEN @MaxOfMin AND @MaxOfMax) OR (@NewDate < @Current) 
	BEGIN
		SELECT 1 
	END 
	ELSE
		SELECT 0 
END 
ELSE IF @OldDate BETWEEN @MinOfMax AND @MaxOfMax 
BEGIN 
	IF (@NewDate < @MinOfMin) OR (@NewDate BETWEEN @MinOfMin AND @MinOfMax) 
	BEGIN
		SELECT 3 
	END 
	ELSE
		SELECT 0 
END 
ELSE IF (@NewDate < @MinOfMin) OR (@NewDate > @MaxOfMax) OR ((SELECT count(*) FROM Reservations 
																WHERE [UID] = @Uid AND id <> @ReservationId AND (@NewDate BETWEEN FLOOR(CAST(StartDate AS float)) 
																	AND DATEADD(DAY, 1, FLOOR(CAST(StartDate AS float))))) <> 0) 
BEGIN
	SELECT 2 
END 
ELSE
	SELECT 0
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_Reservation_SelectByDateAndResourceID_MiniRF]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_Reservation_SelectByDateAndResourceID_MiniRF]
GO
CREATE PROCEDURE [dbo].[sp_Reservation_SelectByDateAndResourceID_MiniRF]
	@ResourceIDs nvarchar(1024),
	@startDate datetime,
	@endDate datetime
AS
BEGIN
	declare @newStartDate DateTime
	SET @newStartDate = Dateadd(day, -1, @startDate)
	declare @newEndDate DateTime 
	SET @newEndDate = Dateadd(day, 1, @endDate)
	--========================================================================
	DECLARE @tblRCids1 	TABLE(ID INT)
	DECLARE @tblRCids 	TABLE(ID INT)
	DECLARE @indexBegin int
	DECLARE @indexEnd int
	DECLARE @resourceId INT
	INSERT INTO @tblRCids SELECT Data FROM udfSplitString(@ResourceIDs,',') WHERE data is not null and data <> ''
	INSERT INTO @tblRCids1 select [ID] FROM @tblRCids
	insert into @tblRCids1
		SELECT VirtualResourceId FROM ChildResources WHERE ChildResourceId IN (SELECT t.id from @tblRCids t)
	insert into @tblRCids1	
		SELECT ChildResourceId FROM ChildResources  WHERE VirtualResourceId IN (SELECT t.id from @tblRCids t)
	insert into @tblRCids1	
		SELECT cr2.VirtualResourceId FROM ChildResources cr1
						INNER JOIN ChildResources cr2 ON cr1.ChildResourceId = cr2.ChildResourceId
						WHERE cr1.VirtualResourceId <> cr2.VirtualResourceId AND cr1.VirtualResourceId IN (SELECT t.id from @tblRCids t)
	DECLARE @tempResources	TABLE(ID INT, PreBufferTime INT , PostBufferTime INT)
	INSERT INTO @tempResources SELECT DISTINCT r.[ID], PreBufferTime, PostBufferTime FROM @tblRCids1 t INNER JOIN Resources r ON t.ID = r.id
SELECT id, 
       CASE 
         WHEN Datepart(hh, startdate) = 12 
              AND Datepart(mi, startdate) = 0 
              AND Datepart(ss, startdate) = 0 THEN Dateadd(ss, 1, startdate) 
         ELSE startdate 
       END AS StartDate, 
       CASE 
         WHEN Datepart(hh, enddate) = 12 
              AND Datepart(mi, enddate) = 0 
              AND Datepart(ss, enddate) = 0 THEN Dateadd(ss, 1, enddate) 
         ELSE enddate 
       END AS EndDate, 
       [Subject],OrganizerName,
       organizeremail, 
       ressourceid,
	   [uid]
FROM   (SELECT VR.id, 
               ( CASE 
                   WHEN startdate < @startDate THEN @startDate 
                   ELSE pbstartdate 
                 END )    AS StartDate, 
               ( CASE 
                   WHEN enddate > @endDate THEN @endDate 
                   ELSE pbenddate 
                 END )    AS EndDate, 
               organizeremail, 
               ressourceid,[Subject],OrganizerName,[uid]
        FROM   
        (
				SELECT reservations.id, 
                       reservations.startdate AS StartDate, 
                       reservations.enddate   AS EndDate, 
                       ( CASE 
                           WHEN t.prebuffertime <> 0 THEN 
                           Dateadd(minute, -( t.prebuffertime ), 
                           dbo.reservations.startdate) 
                           ELSE reservations.startdate 
                         END )                AS PBStartDate, 
                       ( CASE 
                           WHEN t.postbuffertime <> 0 THEN 
                           Dateadd(minute, t.postbuffertime, 
                           dbo.reservations.enddate) 
                           ELSE reservations.enddate 
                         END )                AS PBEndDate, 
                       reservations.ressourceid, 
                       reservations.organizeremail ,
					   reservations.[Subject],
					   reservations.[OrganizerName],
					   reservations.[UID]
                FROM   reservations with (index = idx_reservation_rf_2961)
                       INNER JOIN @tempResources t 
                               ON reservations.ressourceid = t.id 
                WHERE  ( 
							StartDate < @newEndDate and EndDate > @newStartDate
                            and
                            reservations.active = 1
                         )
        ) AS VR 
        WHERE  (pbstartdate < @EndDate  AND pbenddate > @StartDate) 
   ) tblReservation
END
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetResourcesReservationProcessed]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetResourcesReservationProcessed]
GO
CREATE PROCEDURE [dbo].[GetResourcesReservationProcessed]
    @ResourceEmail NVARCHAR(255),
    @ReservationUid VARCHAR(450),
    @StartTime DATETIME,
    @UpdateType INT,
    @CurrentReservationId INT,
    @Active INT
AS
BEGIN
    -- SET NOCOUNT ON added to prevent extra result sets from	
    SET NOCOUNT ON;
    DECLARE @HandledResources NVARCHAR(4000)
    DECLARE @OldChildrentResources NVARCHAR(4000)
    DECLARE @VrResources NVARCHAR(4000) = ''
    DECLARE @IsVRBook TINYINT = 0
    DECLARE @IsChangedVR INT = 0
    DECLARE @IsIncludeOrganizer TINYINT = 1
    DECLARE @Table_ResourcesEmails Table (Id int ,Data NVARCHAR(4000))
    DECLARE @Table_HandledResources Table (Id int ,Data NVARCHAR(4000))
    DECLARE @Table_VRResources Table (Id int ,Data NVARCHAR(4000))	
    DECLARE @ResourcesEmails NVARCHAR(Max)
    SELECT @ResourcesEmails = ResourceList FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid
    -- In case replace resource
    DECLARE @ReplaceWithResource NVARCHAR(255)
    DECLARE @OldGUID NVARCHAR(255) = ''
    DECLARE @OldReservationId int = -1,@VrReservationId INT = -1
    SELECT @ReplaceWithResource = ReplaceWithResource,@OldGUID = OldGUID FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid
    SELECT @OldReservationId = id FROM Reservations WHERE [GUID] = @OldGUID
    IF (@CurrentReservationId = @OldReservationId OR EXISTS (SELECT id FROM Reservations where VRReservationId = @OldReservationId))
        AND EXISTS (SELECT 1 FROM RC_Reservations_Temp 
            WHERE [UID] = @ReservationUid AND [ChildResourcesEmail] LIKE '%'+ @ResourceEmail +'%')
    BEGIN
        IF @UpdateType <> -1
        BEGIN
            SET @UpdateType = -1
            SET @IsChangedVR = 1
        END
    END
    --Get VR childrent emails
    IF @UpdateType = -1 --New reservation
    BEGIN
        IF @IsIncludeOrganizer = 0
            SELECT @VrResources = [ChildResourcesEmail] FROM RC_Reservations_Temp 
            WHERE [UID] = @ReservationUid AND [ChildResourcesEmail] LIKE '%'+ @ResourceEmail +'%'
        ELSE
            SELECT @VrResources = [ChildResourcesEmail] FROM RC_Reservations_Temp 
            WHERE [UID] = @ReservationUid AND [ChildResourcesEmail] LIKE '%'+ @ResourceEmail +'%'
    END
    ELSE
    BEGIN
        DECLARE @VrResourceId INT
        SELECT @VrResourceId = VR.RessourceId,@OldChildrentResources = @ResourcesEmails,@VrReservationId = id  FROM [dbo].[Reservations] VR 
            WHERE EXISTS(SELECT id FROM Reservations R WHERE R.[id] = @CurrentReservationId AND R.[VRReservationId] = VR.id)
            AND (VR.GUID = @OldGUID OR @OldGUID is null OR @OldGUID = '')
        ;WITH CTE AS
        (
            select RessourceMail from Resources r where exists(select ChildResourceId from ChildResources where VirtualResourceId = @VrResourceId AND ChildResourceId = r.id)
        )
        SELECT @VrResources = CASE(@VrResources) WHEN '' THEN  CTE.RessourceMail ELSE COALESCE(@VrResources + ';', '') + CTE.RessourceMail END FROM CTE
    END
    --Get attendees list from reservation
    INSERT INTO @Table_ResourcesEmails SELECT * FROM [dbo].[udfSplitString](@ResourcesEmails, ';')
    --Check booking process
    IF @UpdateType=-1 AND NOT EXISTS(SELECT ReservationUid FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid)
    BEGIN
        DECLARE @NumberResourceInBook int
        SELECT @NumberResourceInBook = COUNT(Id) FROM @Table_ResourcesEmails
        IF @NumberResourceInBook>1 
        BEGIN
            UPDATE  dbo.ReservationsProcessQueue
            SET     dbo.ReservationsProcessQueue.LatestResources = @ResourceEmail ,
                 dbo.ReservationsProcessQueue.DeletedResources =  null
            WHERE   dbo.ReservationsProcessQueue.ReservationUid = @ReservationUid
            --INSERT INTO ReservationsProcessQueue(ReservationUid,LatestResources,DeletedResources) VALUES(@ReservationUid,@ResourceEmail,NULL)
            --SET @HandledResources = @ResourceEmail
        END
        ELSE
        BEGIN
                    UPDATE  dbo.ReservationsProcessQueue
            SET     dbo.ReservationsProcessQueue.LatestResources = null ,
                 dbo.ReservationsProcessQueue.DeletedResources =  null
            WHERE   dbo.ReservationsProcessQueue.ReservationUid = @ReservationUid
            --INSERT INTO ReservationsProcessQueue(ReservationUid,LatestResources,DeletedResources) VALUES(@ReservationUid,NULL,NULL)
        END
    END
    ELSE
    BEGIN
        IF (@Active <> 0 OR @VrResources <> '' 
			OR (@Active = 0 AND (@OldGUID <> '' OR @ReplaceWithResource IS NOT NULL OR @ReplaceWithResource <> ''))) -- in case move order: RTS call deleted resource first and new reource later
        BEGIN
            SELECT @HandledResources = LatestResources FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid
            IF @HandledResources IS NOT NULL
                SET @HandledResources = @HandledResources + ';' + @ResourceEmail
            ELSE
                SET @HandledResources = @ResourceEmail
            INSERT INTO @Table_HandledResources SELECT * FROM [dbo].[udfSplitString](@HandledResources, ';')
            IF NOT EXISTS(SELECT re.Id FROM @Table_ResourcesEmails re LEFT JOIN @Table_HandledResources rh ON re.Data = rh.Data WHERE rh.Data IS NULL AND re.Data IS NOT NULL)
                UPDATE ReservationsProcessQueue SET LatestResources = NULL WHERE ReservationUid = @ReservationUid
            ELSE
                UPDATE ReservationsProcessQueue SET LatestResources = @HandledResources WHERE ReservationUid = @ReservationUid
        END
		IF(@VrResources <> '' AND EXISTS(SELECT rh.ID FROM ReservationHistory rh WHERE rh.ID = @CurrentReservationId AND rh.BusyStatus = 'TENTATIVE')
				AND NOT EXISTS (SELECT 1 FROM Reservations WHERE VRReservationId = @VrReservationId AND BusyStatus = 'TENTATIVE'))
		BEGIN
			UPDATE ReservationsProcessQueue SET LatestResources = NULL WHERE ReservationUid = @ReservationUid
		END
    END
    IF @VrResources <> ''--This could be a part of VR resource 
    BEGIN		
        INSERT INTO @Table_VRResources SELECT * FROM [dbo].[udfSplitString](@VrResources, ';')
        IF (@Active = 0 OR
		NOT EXISTS (SELECT vr.Id FROM  @Table_VRResources vr LEFT JOIN @Table_HandledResources re ON vr.Data = re.Data WHERE re.Data IS NULL AND vr.Data IS NOT NULL)
			OR 
			( EXISTS(SELECT rh.ID FROM ReservationHistory rh WHERE rh.ID = @CurrentReservationId AND rh.BusyStatus = 'TENTATIVE')
				AND NOT EXISTS (SELECT 1 FROM Reservations WHERE VRReservationId = @VrReservationId AND BusyStatus = 'TENTATIVE')) -- incase of accept for delegate resource
		)
        BEGIN
            SET @IsVRBook = 1
            IF @Active = 0--Case a childrent resource is deleted, mark VR reservation to delete				
            BEGIN
                UPDATE Reservations SET Active = 0 WHERE id IN (SELECT TOP 1 VRReservationId FROM Reservations WHERE id=@CurrentReservationId) AND Active = 1
             	IF(@ReplaceWithResource IS NULL OR @ReplaceWithResource = '')
             		SET @VrResources = ''
                SET @IsChangedVR = 0	
            END
            ELSE
            BEGIN
                SELECT TOP 1 @IsChangedVR =  r.id FROM Reservations r INNER JOIN Resources res ON r.RessourceId = res.id
                WHERE EXISTS (SELECT 1 FROM Reservations r1 
                                WHERE r1.id = @CurrentReservationId AND r1.UID = r.UID 
                                AND r1.StartDate = r.StartDate 
                                AND r1.RessourceId <> r.RessourceId)
                  AND Active = 1
			  AND r.IsRecurring = (SELECT IsRecurring FROM Reservations r1 
                                WHERE r1.id = @CurrentReservationId AND r1.UID = r.UID 
                                AND r1.StartDate = r.StartDate 
                                AND r1.RessourceId <> r.RessourceId)
                AND r.RessourceId IN (SELECT cr.ChildResourceId FROM ChildResources cr WHERE cr.VirtualResourceId = @VrResourceId)
                AND res.RessourceMail IN (SELECT Data FROM @Table_HandledResources)
                SET @IsVRBook = 1
               UPDATE Reservations SET Active = 0 WHERE id IN (SELECT TOP 1 VRReservationId FROM Reservations WHERE id=@IsChangedVR) AND Active = 1
            END
        END		
    END
    ELSE--This is a normal booking
    BEGIN
        IF @Active = 0--In case deleted of childrent resources(second child hit), set it as a processing of VR booking		
        BEGIN
            IF EXISTS(SELECT id FROM Reservations R WHERE R.[id] = @CurrentReservationId AND R.[VRReservationId] = R.id) 
            BEGIN
                SET @IsVRBook = 1

				INSERT INTO @Table_HandledResources SELECT * FROM [dbo].[udfSplitString]((SELECT LatestResources FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid), ';')
				INSERT INTO @Table_HandledResources SELECT * FROM [dbo].[udfSplitString](@ResourceEmail, ';')

				DECLARE @Table_ResourcesList Table (Id int,Data NVARCHAR(4000))
				INSERT INTO @Table_ResourcesList SELECT * FROM [dbo].[udfSplitString]((SELECT ResourceList FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid), ';')

				IF NOT EXISTS (SELECT 1 FROM @Table_ResourcesList tbl1 LEFT JOIN @Table_HandledResources tbl2 ON tbl1.Data = tbl2.Data WHERE tbl2.Data IS NULL)
				BEGIN
					 UPDATE ReservationsProcessQueue SET LatestResources = NULL WHERE ReservationUid = @ReservationUid
				END
            END
        END
    END

	-- Update master record after all child resource is changed from tentattive to transfer
	IF(@VrReservationId <> -1 AND NOT EXISTS (SELECT TOP 1 1 FROM Reservations r WHERE IsRecurring <> 2 AND r.[UID] = @ReservationUid AND r.BusyStatus = 'TENTATIVE' 
		AND EXISTS (SELECT TOP 1 cr.ChildResourceId FROM ChildResources cr WHERE cr.VirtualResourceId = @VrResourceId AND cr.ChildResourceId = r.RessourceId))
		AND EXISTS(SELECT rh.ID FROM ReservationHistory rh WHERE rh.ID = @CurrentReservationId AND rh.BusyStatus = 'TENTATIVE'))
	BEGIN
		UPDATE Reservations Set BusyStatus = 'BUSY' WHERE UID = @ReservationUid
	END

    SELECT LatestResources AS HandledResources,@VrResources AS VRResources,@IsVRBook AS IsVRBook,@IsChangedVR AS IsChangedVR,@ReplaceWithResource as ReplaceWithResource,@OldGUID as OldGUID FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid    
END
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MOVE_TEMP_ORDERS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[MOVE_TEMP_ORDERS]
GO
CREATE PROCEDURE [dbo].[MOVE_TEMP_ORDERS]
	@ResourceEmail NVARCHAR(255),
	@ResourceId INT,
	@ReservationId INT,
	@StartTime DATETIME,
	@Uid NVARCHAR(450)
AS
BEGIN TRANSACTION
	DECLARE @OrderPlaced INT
	DECLARE @TempReservationId AS INT
	DECLARE @IsRecurring AS INT
	DECLARE @ReplaceWithRes NVARCHAR(256)
	DECLARE @oldReservationID INT = -1
	DECLARE @oldResourceId INT = -1
	DECLARE @InsertedOrders TABLE(ReservationId INT, Guid NVARCHAR(256), StartTime DATETIME, EndTime DATETIME, OldReservationId INT)

	SET @OrderPlaced = 0
	IF (SELECT COUNT(ChildResourceId) FROM ChildResources WHERE VirtualResourceId = @ResourceId) <> 0 
	BEGIN
		DECLARE Cursor_TempReservation CURSOR FOR 
		SELECT [Id], IsRecurring, ReplaceWithReservation FROM RC_Reservations_Temp WHERE [Uid] = @Uid ORDER BY LastUpdated DESC
	END
	ELSE
	BEGIN
		DECLARE Cursor_TempReservation CURSOR FOR 
		SELECT [Id], IsRecurring, ReplaceWithReservation FROM RC_Reservations_Temp 
		WHERE RessourceId = @ResourceId AND [Uid]= @Uid ORDER BY LastUpdated DESC
	END
	--GET TEMP RESERVATIONS
	OPEN Cursor_TempReservation
		FETCH NEXT FROM Cursor_TempReservation INTO @TempReservationId, @IsRecurring, @ReplaceWithRes
	IF @@FETCH_STATUS = 0 --ONLY SELECT FIRST AND IGNORE THE REST.
	BEGIN
		IF (@IsRecurring = 0) 
		BEGIN
			--Whether this reservation will be replaced
			IF @ReplaceWithRes IS NOT NULL
			BEGIN
				DECLARE @vrReservation INT = -1 
				DECLARE @activeOlderReservation INT = 0 
				DECLARE @reservationUID NVARCHAR(255) = NULL 
				DECLARE @oldResourceEmail NVARCHAR(255) = NULL 
				DECLARE @attendees NVARCHAR(4000) 
				SELECT @vrReservation = VRReservationId, @activeOlderReservation = Active, @reservationUID = [uid], @oldResourceId = RessourceId 
				FROM Reservations WHERE [GUID] = @ReplaceWithRes

				SELECT @attendees = Attendees FROM Reservations WHERE id = @ReservationId
				--IF @vrReservation <> -1
				-- SELECT @ReplaceWithRes = [GUID] FROM Reservations WHERE id = @vrReservation
				SELECT @oldReservationID = Reservations.Id,@oldResourceEmail = Resources.RessourceMail 
				FROM Reservations 
				INNER JOIN Resources ON Reservations.ressourceid = Resources.id 
				WHERE [GUID] = @ReplaceWithRes

				EXECUTE [dbo].[usp_MoveOrderToNewResouce] @ReplaceWithRes, @ReservationId ,@OrderPlaced OUT

				DECLARE @waitingReservation INT = -1
				DECLARE @Table_VRResources Table (Id INT, Data NVARCHAR(4000)) 
				DECLARE @Table_ResourcesEmails Table (Id INT, Data NVARCHAR(4000))
				DECLARE @removeAnyChild INT = 1
				DECLARE @resourceList NVARCHAR(250) = ''

				DECLARE @LatestResources NVARCHAR(250) = ''
				SELECT @waitingReservation = WaitingReservation, @resourceList = ResourceList,@LatestResources = LatestResources 
				FROM ReservationsProcessQueue WHERE ReservationUid = @reservationUID
				SET @resourceList = REPLACE(@resourceList,@ResourceEmail + ';','')
				SET @resourceList = REPLACE(@resourceList,@ResourceEmail,'')

				IF(@resourceList = '')
					UPDATE ReservationsProcessQueue SET ResourceList = NULL, ReplaceWithResource = NULL, OldGUID = NULL, WaitingReservation = NULL, LatestResources = NULL 
					WHERE ReservationUid = @reservationUID
				ELSE
					UPDATE ReservationsProcessQueue SET ResourceList = @resourceList, ReplaceWithResource = NULL, OldGUID = NULL, WaitingReservation = NULL, LatestResources = NULL 
					WHERE ReservationUid = @reservationUID

				INSERT INTO @Table_ResourcesEmails SELECT * FROM [dbo].[udfSplitString](@attendees, ';')
				IF(@vrReservation = 0)
				BEGIN
					UPDATE Reservations SET VRReservationId = NULL WHERE id = @oldReservationID
					DECLARE @VrResources NVARCHAR(4000)
					;WITH CTE AS
					(
						SELECT RessourceMail FROM Resources r WHERE EXISTS(SELECT ChildResourceId FROM ChildResources WHERE VirtualResourceId = @oldResourceId AND ChildResourceId = r.id)
					)
					SELECT @VrResources = CASE(@VrResources) WHEN '' THEN CTE.RessourceMail ELSE COALESCE(@VrResources + ';', '') + CTE.RessourceMail END FROM CTE
					INSERT INTO @Table_VRResources SELECT * FROM [dbo].[udfSplitString](@VrResources, ';')
					
					IF NOT EXISTS (SELECT vr.Id FROM  @Table_VRResources vr LEFT JOIN @Table_ResourcesEmails re ON vr.Data = re.Data WHERE re.Data IS NULL AND vr.Data IS NOT NULL)
					BEGIN
						SET @removeAnyChild = 0
					END
				END
				IF (
				(@activeOlderReservation = 0 AND CHARINDEX(@oldResourceEmail,@LatestResources) < 1 )
				OR @activeOlderReservation <> 0  
				OR (
						(@vrReservation <> -1 AND @vrReservation IS NOT NULL) 
						AND @removeAnyChild = 1
					)
				OR (
					@activeOlderReservation <> 0 
					AND (@vrReservation = -1 OR @vrReservation IS NULL) 
					AND (@waitingReservation IS NULL OR  @waitingReservation <> @oldReservationID) 
					)
				)
				SET @oldReservationID = -1
			END
			ELSE
			BEGIN
				--PRINT 'TEST MESSAGE'
				--MAKE ORDERS PERMANENT
				EXECUTE [dbo].[MakeOrdersPermanent] @ReservationId, @TempReservationId, @OrderPlaced OUT
			END
			--REMOVE TEMPORARY DATA
			EXECUTE DBO.DELETE_TEMP_RESERVATION @TempReservationId
			IF (@@Error <> 0)
			BEGIN
				ROLLBACK
				RAISERROR('Error Removing data for temp reservaiton',16,1)
			END
			IF @OrderPlaced = 1
			BEGIN
				INSERT INTO @InsertedOrders SELECT [Id], Guid, StartDate, EndDate, @oldReservationID FROM Reservations WHERE [Id] = @ReservationId
			END
		END --@IsRecurring = 0
		ELSE 
		BEGIN
			SET @OrderPlaced = 0
			--GET ALL THE ACTUAL INSTANCES
			DECLARE @InstanceId INT
			DECLARE @InstanceStartTime DATETIME
			DECLARE @InstanceEndTime DATETIME  
			DECLARE CURSOR_ActualInstance CURSOR FOR
				SELECT [Id],StartDate,EndDate FROM Reservations WHERE ParentReservationId = @ReservationId

			OPEN CURSOR_ActualInstance
			FETCH NEXT FROM CURSOR_ActualInstance INTO @InstanceId, @InstanceStartTime, @InstanceEndTime
			WHILE @@FETCH_STATUS = 0
			BEGIN
				-- GET THE CORRESPONDING TEMP INSTANCE
				DECLARE @TempInstanceId INT
				DECLARE Cursor_TempInstance CURSOR FOR 
					SELECT [Id] FROM RC_Reservations_Temp 
					WHERE RessourceId = @ResourceId 
						AND StartDate = @InstanceStartTime AND EndDate = @InstanceEndTime 
						AND (id = @TempReservationId OR ParentReservationId = @TempReservationId)  
						AND IsRecurring = 1 
					ORDER BY LastUpdated DESC
				OPEN Cursor_TempInstance 
					FETCH NEXT FROM Cursor_TempInstance INTO @TempInstanceId
				IF @@FETCH_STATUS = 0 --ONLY PICK ONE RESERVATION
				BEGIN 
					--MAKE TEMP INSTANCE PERMANENT
					EXECUTE [dbo].[MakeOrdersPermanent] @InstanceId, @TempInstanceId, @OrderPlaced OUT
					IF @@Error <> 0
					BEGIN
						ROLLBACK
						RAISERROR('Error Inserting Instance Data', 16, 1)
					END
					--REMOVE TEMPORARY DATA
					EXECUTE DBO.DELETE_TEMP_RESERVATION @TempInstanceId
					IF @@Error <> 0
					BEGIN
						ROLLBACK
						RAISERROR('Error Removing data for temp Instance', 16, 1)
					END
					IF @OrderPlaced = 1
					BEGIN
						INSERT INTO @InsertedOrders SELECT [Id], [Guid], StartDate, EndDate,@oldReservationID FROM Reservations WHERE [Id] = @InstanceId
						SET @OrderPlaced = 0
					END
					FETCH NEXT FROM Cursor_TempInstance INTO @TempInstanceId
				END
				CLOSE Cursor_TempInstance
				DEALLOCATE Cursor_TempInstance 
				FETCH NEXT FROM CURSOR_ActualInstance INTO @InstanceId, @InstanceStartTime, @InstanceEndTime
			END
			--REMOVE TEMPORARY DATA FOR MASTER INSTANCE
			EXECUTE DBO.DELETE_TEMP_RESERVATION @TempReservationId
			IF @@Error <> 0
			BEGIN
				ROLLBACK
				RAISERROR('Error Removing data for temp Instance',16,1)
			END
			CLOSE CURSOR_ActualInstance
			DEALLOCATE CURSOR_ActualInstance
		END 
	END --End Cursor_TempReservation
	CLOSE Cursor_TempReservation
	DEALLOCATE Cursor_TempReservation 
COMMIT --End Transaction
SELECT * FROM @InsertedOrders
GO
 DECLARE @lastIdOfParametersInTableKey INT
 SELECT @lastIdOfParametersInTableKey = Max(id)+1 FROM [Parameters]
 
 IF NOT EXISTS (SELECT [dbo].[Parameters].[key]
             FROM   [dbo].[Parameters]
			 WHERE  [dbo].[Parameters].[key] = 'BookingManager.RestoringTime')	  
      BEGIN			 		 
			 INSERT [dbo].[Parameters] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [key], [Name], [Value]) 
			 VALUES (@lastIdOfParametersInTableKey, GETDATE(), NULL, GETDATE(), NULL, N'BookingManager.RestoringTime', NULL,10)		 		     
      END
UPDATE TableKeys SET LastID = @lastIdOfParametersInTableKey WHERE TableName = 'Parameters'
GO

---- HaLV added
DECLARE @maxIdTree int = (select Max(id) from Tree)
IF NOT EXISTS (SELECT 1 FROM Tree WHERE [Key] = 'BookingManager')
BEGIN
 SET @maxIdTree = @maxIdTree + 1
 INSERT INTO [dbo].[Tree] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [parentNodeId], [Key], [Caption], [SortOrder], [Description], [URL], [IsApplicationNode], [FunctionId], [IconKey], [CustomCalendarId], [ExtraID1], [NodeType], [FullPath]) VALUES (@maxIdTree, GETDATE(), NULL, NULL, NULL, 4, N'BookingManager', N'Booking Manager', 9, NULL, NULL, 1, 1519259, N'Booking Manager', 1, NULL, 0, NULL)

 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 1 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ( [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES (GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 1, 1, NULL)
 END
 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 2 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ( [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES ( GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 2, 1, NULL)
 END
 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 3 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ([Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES ( GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 3, 1, NULL)
 END
 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 4 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ( [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES ( GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 4, 1, NULL)
 END
 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 5 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ( [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES ( GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 5, 1, NULL)
 END
END
-- Toolbar
 
DECLARE @maxIdToolbarFunctions int = (select Max(id) from ToolbarFunctions)
IF NOT EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@SaveAndClose')
BEGIN
 SET @maxIdToolbarFunctions =  @maxIdToolbarFunctions +1
INSERT INTO [dbo].[ToolbarFunctions] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [FunctionName], [Caption], [DescriptionShort], [requestConfirmation], [iconRef], [ACLtype], [IconRef2007]) VALUES (@maxIdToolbarFunctions, NULL, NULL, NULL, NULL, N'@SaveAndClose', N'Save and Close', NULL, NULL, NULL, 4, NULL)
END

--Precompile
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spEXECsp_RECOMPILE]') AND TYPE IN (N'P', N'PC'))
DROP PROCEDURE [dbo].[spEXECsp_RECOMPILE]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spEXECsp_RECOMPILE] AS 
SET NOCOUNT ON 
-- 1 - Declaration statements for all variables
DECLARE @TableName varchar(128)
DECLARE @OwnerName varchar(128)
DECLARE @CMD1 varchar(8000)
DECLARE @TableListLoop int
DECLARE @TableListTable table (UIDTableList int IDENTITY (1,1), OwnerName varchar(128), TableName varchar(128), ObjType varchar(128))
-- 2 - Outer loop for populating the database names
INSERT INTO @TableListTable(OwnerName, TableName, ObjType)
SELECT u.[Name], o.[Name], o.[type] FROM sys.objects o INNER JOIN sys.schemas u ON o.schema_id  = u.schema_id WHERE o.Type in ('U','P','IF','TF','FN','V') ORDER BY o.[type]
-- 3 - Determine the highest UIDDatabaseList to loop through the records
SELECT @TableListLoop = MAX(UIDTableList) FROM @TableListTable
-- 4 - While condition for looping through the database records
WHILE @TableListLoop > 0
 BEGIN
 -- 5 - Set the @DatabaseName parameter
 SELECT @TableName = TableName,  @OwnerName = OwnerName FROM @TableListTable WHERE UIDTableList = @TableListLoop
 -- 6 - String together the final backup command
 SELECT @CMD1 = 'EXEC sp_recompile ' + '[' + @OwnerName + '.' + @TableName + ']' + char(13)
 -- 7 - Execute the final string to complete the backups
 -- SELECT @CMD1
 EXEC (@CMD1)
 -- 8 - Descend through the database list
 SELECT @TableListLoop = @TableListLoop - 1
 END
SET NOCOUNT OFF
GO
exec [dbo].[spEXECsp_RECOMPILE]
GO
UPDATE [DBVersion] SET [Value] = '3.8.0004.0023' WHERE [Property]='dbVersion'
GO